// UDataFile.cp
// UDataFile.h
// ----------------------------------------------------------------------------------
// Data FIle class for the Spell Checker project.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// A data file is an abstract data class representing a file on disk.
// Internally it is stored as a linked list of 'pages' in the disk file.
// A user picks 'pages' to be read and can specify a header in the file
// that is ignored.
//
// Implementation Example
// 
// UDataFile is used by the spell checker to read in compressed pages from
// disk that hold the word list within a dictionary.  A header contains
// the location of the index, the number of words and other such data.
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/11/94
//			Made the buffer into an abstract C++ class that was basically
//			an abstract datafile class.
// ----------------------------------------------------------------------------------

#ifndef _UBLOOM_
#define _UBLOOM_

// ----------------------------------------------------------------------------------
// Includes

#include "Tspell.h"
#include "Uio.h"

#define _DEBUG_SPELL_

#include <stdio.h>

// ----------------------------------------------------------------------------------


#define By_Key  1				// Size by number of keys
#define By_Byte 0				// Size by the number of bytes

// ----------------------------------------------------------------------------------
// UBloom Class Interface

class UBloom {
public:
	// Constructor and Destructor
	UBloom(unsigned long Num_Keys, long theNumBits, short how);
	virtual ~UBloom();

	// Main Methods
	void 	Insert(char *Word, short length);		// Inserts a word
	short	Test(char *Word, short length);			// Tests for a word
	void	Reset();											// Resets the filter
	short	FRead(Uio *InFile, long Offset = 0); 	// Reads a filter from a file
	short	FWrite(Uio *OutFile, long Offset = 0); // Writes a filter to a file
	int	FWrite2(FILE *OutputFile, long Offset = 0);
	unsigned long
			Get_Insertions();								// Number of insertions made
	unsigned long
			Get_OptKeys();									// Optimal number of insertions that can be made
	size_t GetBloomSizeInBytes();

#ifdef _DEBUG_SPELL_
	// For testing only
	void	Dump();	// Dumps the offset of all set bits to the screen
#endif

protected:
	UInt8			*Filter;		  				// One byte for the filter
	long			BloomSizeInBits;  				// Number of bits in the filter
	long        BloomSizeInBytes; 				// Size of the filter in bytes
	long			NumBits;		  				// Number of bits set or test per token insert or test
	unsigned long	NumKeys;		  				// Number of keys added thus far
	unsigned long	OptNumKeys;		  				// Optimal number of keys that can be added
	unsigned char	*random_8;
	unsigned long	*random_32;
};	/* UBloom */

#endif


